#!/usr/bin/env bash                                                                                                                            
                                                                                                                                               
[[ `ps aux | grep "zkwork_ironminer --pool" | grep -v grep | wc -l` != 0 ]] &&                                                                      
    echo  "/hive/miners/custom/zkwork_ironminer miner is already running" > log &&                                                             
    exit 1                                                                                                                                     
                                                                                                                                               
cd `dirname $0`                                                                                                                                
                                                                                                                                               
. zkwork_ironminer.conf                                                                                                                        
                                                                                                                                               
echo "ADDRESS = "$ADDRESS > log                                                                                                                
echo "POOL = "$POOL >> log                                                                                                                     
echo "WORKER_NAME = "$WORKER_NAME >> log                                                                                                       
echo "IF_TLS = "$IF_TLS >> log                                                                                                     
                                                                                                                                               
if [ -z "$IF_TLS" ]; then                                                                                                                                       
    if [ $(gpu-detect AMD) -ne 0 ]; then
        ./zkwork_ironminer_opencl --pool $POOL --address $ADDRESS --worker_name $WORKER_NAME > zkwork_ironminer.log 2>&1
    else
        ./zkwork_ironminer --pool $POOL --address $ADDRESS --worker_name $WORKER_NAME > zkwork_ironminer.log 2>&1
    fi
else
    if [ $(gpu-detect AMD) -ne 0 ]; then
        ./zkwork_ironminer_opencl --pool $POOL --address $ADDRESS --worker_name $WORKER_NAME --tls > zkwork_ironminer.log 2>&1
    else
        ./zkwork_ironminer --pool $POOL --address $ADDRESS --worker_name $WORKER_NAME --tls > zkwork_ironminer.log 2>&1
    fi
fi
